$Optimize On
$Include <RAPIDQ2.INC>
$Include <RSOCKET.INC>
$TypeCheck On
$AppType Console
Const Title="EORDataGet"
Application.Title=Title
Const Version="1.0"
Declare Function Bin2Int(Text As String) As String
Declare Function Resolve(Text As String) As String
Declare Sub Connect
Declare Sub Disconnect
Declare Sub Log(Text As String)
Declare Sub Main
Declare Sub Printx(Text As String)
Declare Sub Receive
Const Bell=Chr$(&H07)
Const CR=Chr$(&H0D)
Const Del=Chr$(&H08)
Const Host="eor.forbiddengates.net"
Const LF=Chr$(&H0A)
Const NewLine=CR+LF
Const Port=18385
Dim ClientSocket As RSocket
Dim ClientSockID As Long
Dim File As QFileStream
Dim IPSocket As RSocket
Dim Packet As String
Dim Server As String
Dim Status As Long
ClientSockID=-1

Function Bin2Int
 Dim IConvert As Long
 Result=""
 For IConvert=1 To Len(Text)
  Result=Result+Str$(Asc(Mid$(Text,IConvert,1)))+"_"
 Next
 Result=Delete$(Result,Len(Result),1)
End Function

Sub Connect
 Server=Resolve(Host)
 If Server<>"" Then
  ClientSockID=ClientSocket.S
  Printx "Connecting to "+Server+":"+Str$(Port)+"..."
  ClientSocket.Connect(ClientSockID,Server,Port)
  Status=ClientSocket.IsConnected(ClientSockID,0)
  If Status=1 Then
   Printx "Success: Connected. ["+Str$(ClientSockID)+"]"
  Else
   Printx "Error: Couldn't connect. ["+ClientSocket.LastError+"]"
  End If
 End If
End Sub

Sub Disconnect
 ClientSocket.EndConnection(ClientSockID)
 ClientSocket.Close(ClientSockID)
 ClientSockID=-1
End Sub

Sub Log
 If FileExists("Log.txt")=0 Then
  If File.Open("Log.txt",65535) Then
   File.Close
  End If
 End If
 If File.Open("Log.txt",1) Then
  With File
   .Seek(0,2)
   .WriteLine(Text)
   .Close
  End With
 End If
End Sub

Sub Main
 SetConsoleTitle Title+" v"+Version
 While 1
  If ClientSockID=-1 Then
   Connect
  Else
   If ClientSocket.IsServerReady(ClientSockID) Then
    Receive
   End If
  End If
  DoEvents
  Sleep 1/1000
 Wend
End Sub

Sub Printx
 Print "["+Time$+"] "+ReplaceSubStr$(ReplaceSubStr$(ReplaceSubStr$(ReplaceSubStr$(Text,Bell,""),CR,""),LF,""),Del,"")
End Sub

Sub Receive
 Packet=ClientSocket.Read(ClientSockID,1024)
 If Len(Packet)=0 Then
  Printx "Error: Lost connection to server! ["+ClientSocket.LastError+"]"
  Disconnect
 Else
  Printx "["+Str$(Len(Packet))+"] "+Packet
  Printx Bin2Int(Packet)
  Log("["+Time$+"] "+Packet)
  Log("["+Time$+"] "+Bin2Int(Packet))
  Log()
 End If
End Sub

Function Resolve
 Printx "Resolving '"+Text+"'..."
 Result=IPSocket.AddrByName(Text)
 If Tally(Result,".")<>3 Then
  Printx "Error: Couldn't resolve. ["+IPSocket.LastError+"]"
 End If
End Function

Main 